﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="HotAirStationProfileView.ascx.vb" Inherits="Web.HotAirStationProfileView" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>


<asp:UpdatePanel runat="server" Id="UpdatePanelProfileView" UpdateMode="Conditional" class="mask">
<ContentTemplate>

    <div class="desc">
        <div class="title"><span>Profile name:</span><span runat="server" id="lblProfileName"></span></div>
        <div class="ports">
            <span>Puertos:</span>
            <ol>
                <li runat="server" id="profileActivePort_1" visible="false"></li>
                <li runat="server" id="profileActivePort_2" visible="false"></li>
                <li runat="server" id="profileActivePort_3" visible="false"></li>
                <li runat="server" id="profileActivePort_4" visible="false"></li>
            </ol>
        </div>
        <div class="duration">
            <span>Duración:</span><span runat="server" id="lblProfileDuration"></span>
        </div>						
    </div>

    <ul class="globalactions">
		<li>
            <asp:LinkButton ID="btnProfileUndo" runat="server" CssClass="undo" CommandName="UNDO" OnClick="btnProfileAction_Click">Deshacer</asp:LinkButton>
		</li>
		<li>
            <asp:LinkButton ID="btnProfileNew" runat="server" CssClass="save" CommandName="SAVE" OnClick="btnProfileAction_Click">Guardar</asp:LinkButton>
		</li>
	</ul>

    <div class="graph">

	    <telerik:RadHtmlChart runat="server" ID="LineChart" BorderStyle="None" Width="100%" Height="100%" BackColor="Transparent" BorderColor="white" Transitions="false" Skin="Silk" EnableViewState="false" Visible="false"> 
            <ClientEvents OnSeriesClick="OnClientSeriesClicked"/>
        <Appearance>
            <FillStyle BackgroundColor="Transparent" ></FillStyle>
        </Appearance>
        <ChartTitle Text="Gráfica">
            <Appearance Align="Center" BackgroundColor="Transparent"><TextStyle FontSize="16" Padding="" Margin="-8 0 0 0" Color="white" Bold="false" FontFamily="Myriad W01"/></Appearance>
        </ChartTitle>
        <Legend><Appearance BackgroundColor="Transparent" Position="Top" Visible="False"></Appearance></Legend>
        <PlotArea>
        <YAxis AxisCrossingValue="0" Color="black" Width ="1">
            <LabelsAppearance DataFormatString="{0}" RotationAngle="0" Skip="0" Step="1"><TextStyle FontSize="14" Padding="" Margin="" Color="red" FontFamily="Myriad W01" /></LabelsAppearance>
            <TitleAppearance Position="Top" RotationAngle="360"  Text="(ºC)"><TextStyle FontSize ="14" Padding="0 -20 0 0"  Margin="-25 0 0 0" Bold="true" Color="red" FontFamily="Myriad W01" /></TitleAppearance>
        </YAxis>
        <AdditionalYAxes>
            <telerik:AxisY Name="AdditionalAxis" Color="black"  Width="1">
            <TitleAppearance  Position="Top" RotationAngle="360" Text="(%)" ><TextStyle FontSize="14" Padding="0 0 0 -20" Bold="true" Margin="-25 0 0" Color="#4578fa" /></TitleAppearance>
            <LabelsAppearance><TextStyle Color="#4578fa" FontSize="14" FontFamily="Myriad W01" /></LabelsAppearance>
            </telerik:AxisY>
	    </AdditionalYAxes>
        <XAxis BaseUnit="Seconds" Color="#515151">
            <LabelsAppearance DataFormatString="{0}" RotationAngle="0" Skip="0"><TextStyle FontSize="14" FontFamily="Myriad W01"/></LabelsAppearance>
            <TitleAppearance Position="Bottom"  RotationAngle="0" Text="Seg."><TextStyle FontSize ="14" Margin="-12 -35 0 0" FontFamily="Myriad W01" Bold="true" /></TitleAppearance>
        </XAxis>
        </PlotArea>
        </telerik:RadHtmlChart>

    </div>

    <div class="config">
							
        <ul class="action-menu">				
            <li><a href="#" class="edit">Editar</a></li>
        </ul>
        <ul class="settings">
        <li>
            <span>Mode:</span>
            <a class="red">Air Temp</a>
        </li>
        <li>
            <span>Alarms:</span>
            <a class="green">Ext. Temp > 120º C</a>
        </li>
        <ul>

    </div>
    
    <div id="divPoints" runat="server" class="points">

        <div class="header">
            <asp:LinkButton ID="btnEnviar" runat="server" CssClass="btn" OnClick="ChangedPointParameter"><i class="icon2-arrow-right"></i></asp:LinkButton>
            <div class="nav-points">
                <span>Point</span>
                <span><asp:LinkButton ID="lbtPreviousPoint" runat="server" CommandName="PREVIOUS" OnClick="PointEvent"><</asp:LinkButton></span>
                <span id="lblPointNumber" class="point-number" runat="server">2/2</span>
                <span><asp:LinkButton ID="lbtNextPoint" runat="server" CommandName="NEXT" OnClick="PointEvent">></asp:LinkButton></span>
            </div>
            <ul class="actions">
                <li><asp:LinkButton ID="lbtNewPoint" runat="server" CssClass="plus" CommandName="ADD" OnClick="PointEvent">Nuevo Point</asp:LinkButton></li>
                <li><asp:LinkButton ID="lbtDeletePoint" runat="server" CssClass="minus" CommandName="DELETE" OnClick="PointEvent">Eliminar Point</asp:LinkButton></li>
            </ul>
        </div>
        <ul class="parameters">
            <li class="l1">
                <span>Temp</span>
                <asp:TextBox ID="currentPointTemp" CssClass="temp" runat="server" Text="250" MaxLength="3"></asp:TextBox>
                <ajaxToolkit:FilteredTextBoxExtender ID="ftbex_currentPointTemp" runat="server" TargetControlID="currentPointTemp" ValidChars="1234567890" />
                <span class="sufix">ºC</span>
            </li>
            <li class="l2">
                <span>Flow</span>
                <asp:TextBox ID="currentPointFlow" CssClass="flow" runat="server" Text="80" MaxLength="3"></asp:TextBox>
                <ajaxToolkit:FilteredTextBoxExtender ID="ftbex_currentPointFlow" runat="server" TargetControlID="currentPointFlow" ValidChars="1234567890" />
                <span class="sufix">%</span>
            </li>
            <li class="l3">
                <span>Time</span>
                <asp:TextBox ID="currentPointTime" CssClass="time" runat="server" Text="0m 30s"></asp:TextBox>
            </li>
            <li class="l4">
                <span>Rate</span>
                <asp:TextBox ID="currentPointRate" CssClass="rate" runat="server" Text="0"></asp:TextBox>
                <ajaxToolkit:FilteredTextBoxExtender ID="ftbex_currentPointRate" runat="server" TargetControlID="currentPointFlow" ValidChars="-1234567890" />
                <span class="sufix">ºC/S</span>
            </li>
        </ul>

    </div>
                                  
<!--- Controles ocultos y timer-->
<asp:HiddenField ID="hdnTicks" runat="server" Value="0"/>
<asp:HiddenField ID="hdnTiempoMarca" runat="server" Value="10"/>
<asp:HiddenField ID="hdnEscalaTemp" runat="server" Value="CELSIUS"/>
<asp:HiddenField ID="hdnCambioEscala" runat="server" Value="0"/>
<asp:HiddenField ID="hdnVentanaTiempo" runat="server" Value="30" />

<!-- control ventanas desplazamiento -->
<asp:HiddenField ID="hdnVentanaTiempoMax" runat="server" />
<asp:HiddenField ID="hdnVentanaTiempoMin" runat="server" />
<asp:HiddenField ID="hdnVentanaFinal" runat="server" />
    
<!-- Valores de referencia de la gráfica -->
<asp:HiddenField ID="hdnTempSelected" runat="server" Value="" />
<asp:HiddenField ID="hdnExtTCTempSelected" runat="server" Value="" />
<asp:HiddenField ID="hdnSelectedSerieName" runat="server" Value="" />
<asp:HiddenField ID="hdnSelectedPointIndex" runat="server" Value="" />

<telerik:RadAjaxManager ID="RadAjaxManagerProfileChart" runat="server" OnAjaxRequest="RadAjaxManagerProfileChart_AjaxRequest">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="RadAjaxManagerProfileChart">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="LineChart" UpdatePanelRenderMode="Block"></telerik:AjaxUpdatedControl>
                <telerik:AjaxUpdatedControl ControlID="divPoints" UpdatePanelRenderMode="Block"></telerik:AjaxUpdatedControl>
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManager>

</ContentTemplate>
    <Triggers>
        <asp:AsyncPostBackTrigger ControlID="btnEnviar" EventName="Click" />
        <asp:AsyncPostBackTrigger ControlID="lbtPreviousPoint" EventName="Click" />
        <asp:AsyncPostBackTrigger ControlID="lbtNextPoint" EventName="Click" />
    </Triggers>
</asp:UpdatePanel>

<!-- Controles ajax -->
<ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderProfileView" TargetControlID="UpdatePanelProfileView" BehaviorID="animation" runat="server">    
<Animations>
    <OnUpdated>
        <Sequence>
            <ScriptAction Script="UnlockScreen();" />
        </Sequence>
    </OnUpdated>
</Animations>
</ajaxToolkit:UpdatePanelAnimationExtender>



